/** @file   wingedalien.h
 * @brief   Declaration of WingedAlien - class.
 * @version $Revision: 1.2 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_WINGEDALIEN_H
#define H_WWW_WINGEDALIEN_H

#include "alien.h"


namespace WeWantWar {



/** @class  WingedAlien
 * @brief   Flying alien that shoots fireballs.
 * @author  Tomi Lamminsaari
 *
 */
class WingedAlien : public Alien
{
public:
  ///
  /// Static members
  /// ==============
  
  
  ///
  /// Constructor, destructor
  /// =======================
  
  /** Constructor.
   */
  WingedAlien();
  
  /** Destructor.
   */
  ~WingedAlien();
  
  
  ///
  /// Methods
  /// =======
  
  /** Updates the movements and actions this alien does.
   */
  virtual void update();
  
  /** Redraws this alien
   * @param     pQueue            Pointer to redraw queue
   */
  virtual void redraw( RedrawQueue* pQueue );
  
  /** Kills this alien
   */
  virtual void kill();
  
  /** Makes sound
   * @param     id                ID of the sound we should make.
   */
  virtual void makeSound( GameObject::SoundID id ) const;
  
  /** This alien got hit by given bullet. The bullets can go through the
   * Alien if it was shot by another alien.
   * @param     pB                Pointer to bullet that hit us.
   * @return    'true' if this bullet did hit us. 'false' means it went
   *            through.
   */
  virtual bool hitByBullet( Bullet* pB );
  
  
  
  ///
  /// Getter methods
  /// ==============
  
  /** Returns the type id of this alien.
   * @return    GameObject::TYPE_WINGEDALIEN
   */
  virtual ObjectID::Type objectType() const;
  
protected:

  /** Sets the requested animation
   * @param     aAnimId           Id of the animation
   */
  virtual void setCorrectAnimation( int aAnimId );
   
  /** Attacks the target.
   */
  virtual void attack();
  
  
  
  ///
  /// Members
  /// =======
  
  /** The speed vector. */
  eng2d::Vec2D  m_speedVec;
};


};  // end of namespace

#endif // WINGEDALIEN_H


/**
 * Version history
 * ===============
 * $Log: wingedalien.h,v $
 * Revision 1.2  2006/02/08 22:03:28  lamminsa
 * New animation and graphic system was implemented.
 *
 * Revision 1.1.1.1  2006/01/21 23:02:42  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:17:21+02  lamminsa
 * Initial revision
 *
 */
 
